/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.furniture.FurnitureEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.furniture.model.FurnitureEntityAsset;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.assets.entities.item.ItemEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.item.model.ItemEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.assets.entities.model.EntityChildAssetDescriptor;
import technology.rocketjump.undermount.assets.entities.model.SpriteDescriptor;
import technology.rocketjump.undermount.assets.entities.plant.PlantEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.plant.model.PlantEntityAsset;
import technology.rocketjump.undermount.assets.entities.tags.Tag;
import technology.rocketjump.undermount.assets.entities.tags.TagProcessor;
import technology.rocketjump.undermount.assets.entities.tags.TagType;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.AttachedEntity;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.PhysicalEntityComponent;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.Profession;

public class EntityAssetUpdater {
    private final HumanoidEntityAssetDictionary humanoidEntityAssetDictionary;
    private final ItemEntityAssetDictionary itemEntityAssetDictionary;
    private final FurnitureEntityAssetDictionary furnitureEntityAssetDictionary;
    private final PlantEntityAssetDictionary plantEntityAssetDictionary;
    private final TagProcessor tagProcessor;
    private final Profession defaultProfession;
    private final EntityAssetType branchAssetType;
    private final EntityAssetType leafAssetType;
    private final EntityAssetType fruitAssetType;
    private final EntityAssetType itemBaseLayer;
    private final EntityAssetType humanoidBodyAssetType;
    private final EntityAssetType HUMANOID_HAIR;
    private final EntityAssetType HUMANOID_EYEBROWS;
    private final EntityAssetType HUMANOID_BEARD;
    private final EntityAssetType HUMANOID_LEFT_HAND;
    private final EntityAssetType HUMANOID_RIGHT_HAND;

    @Inject
    public EntityAssetUpdater(ItemEntityAssetDictionary itemEntityAssetDictionary, FurnitureEntityAssetDictionary furnitureEntityAssetDictionary, PlantEntityAssetDictionary plantEntityAssetDictionary, EntityAssetTypeDictionary entityAssetTypeDictionary, ProfessionDictionary professionDictionary, HumanoidEntityAssetDictionary humanoidEntityAssetDictionary, TagProcessor tagProcessor) {
        this.itemEntityAssetDictionary = itemEntityAssetDictionary;
        this.plantEntityAssetDictionary = plantEntityAssetDictionary;
        this.furnitureEntityAssetDictionary = furnitureEntityAssetDictionary;
        this.defaultProfession = professionDictionary.getByName("VILLAGER");
        this.humanoidBodyAssetType = entityAssetTypeDictionary.getByName("HUMANOID_BODY");
        this.branchAssetType = entityAssetTypeDictionary.getByName("PLANT_BRANCHES");
        this.leafAssetType = entityAssetTypeDictionary.getByName("PLANT_LEAVES");
        this.fruitAssetType = entityAssetTypeDictionary.getByName("PLANT_FRUIT");
        this.itemBaseLayer = entityAssetTypeDictionary.getByName("ITEM_BASE_LAYER");
        this.HUMANOID_HAIR = entityAssetTypeDictionary.getByName("HUMANOID_HAIR");
        this.HUMANOID_EYEBROWS = entityAssetTypeDictionary.getByName("HUMANOID_EYEBROWS");
        this.HUMANOID_BEARD = entityAssetTypeDictionary.getByName("HUMANOID_BEARD");
        this.HUMANOID_LEFT_HAND = entityAssetTypeDictionary.getByName("HUMANOID_LEFT_HAND");
        this.HUMANOID_RIGHT_HAND = entityAssetTypeDictionary.getByName("HUMANOID_RIGHT_HAND");
        this.humanoidEntityAssetDictionary = humanoidEntityAssetDictionary;
        this.tagProcessor = tagProcessor;
    }

    public void updateEntityAssets(Entity entity) {
        switch (entity.getType()) {
            case HUMANOID: {
                this.updateHumanoidAssets(entity);
                break;
            }
            case ITEM: {
                this.updateItemAssets(entity);
                break;
            }
            case FURNITURE: {
                this.updateFurnitureAssets(entity);
                break;
            }
            case PLANT: {
                this.updatePlantAssets(entity);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled entity type " + (Object)((Object)entity.getType()) + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void updateHumanoidAssets(Entity entity) {
        HumanoidEntityAttributes attributes = (HumanoidEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
        ProfessionsComponent professionsComponent = entity.getComponent(ProfessionsComponent.class);
        Profession primaryProfession = this.defaultProfession;
        if (professionsComponent != null) {
            primaryProfession = professionsComponent.getPrimaryProfession(this.defaultProfession);
        }
        HumanoidEntityAsset baseAsset = this.humanoidEntityAssetDictionary.getHumanoidEntityAsset(this.humanoidBodyAssetType, attributes, primaryProfession);
        entity.getPhysicalEntityComponent().setBaseAsset(baseAsset);
        entity.getPhysicalEntityComponent().getTypeMap().put(baseAsset.getType(), baseAsset);
        this.addOtherHumanoidAssetTypes(baseAsset.getType(), entity.getPhysicalEntityComponent(), attributes, primaryProfession);
        if (!attributes.getHasHair()) {
            entity.getPhysicalEntityComponent().getTypeMap().remove(this.HUMANOID_HAIR);
        }
        if (attributes.getGender().equals((Object)Gender.FEMALE)) {
            entity.getPhysicalEntityComponent().getTypeMap().remove(this.HUMANOID_EYEBROWS);
            entity.getPhysicalEntityComponent().getTypeMap().remove(this.HUMANOID_BEARD);
        }
        this.addOtherHumanoidAssetTypes(this.HUMANOID_LEFT_HAND, entity.getPhysicalEntityComponent(), attributes, primaryProfession);
        this.addOtherHumanoidAssetTypes(this.HUMANOID_RIGHT_HAND, entity.getPhysicalEntityComponent(), attributes, primaryProfession);
        LinkedList<Tag> attachedTags = new LinkedList<Tag>();
        this.addTags(entity, attachedTags);
        this.tagProcessor.apply(attachedTags, entity);
    }

    private void updatePlantAssets(Entity entity) {
        PhysicalEntityComponent physicalComponent = entity.getPhysicalEntityComponent();
        PlantEntityAttributes attributes = (PlantEntityAttributes)physicalComponent.getAttributes();
        PlantEntityAsset baseAsset = this.plantEntityAssetDictionary.getPlantEntityAsset(this.branchAssetType, attributes);
        physicalComponent.setBaseAsset(baseAsset);
        physicalComponent.getTypeMap().put(this.branchAssetType, baseAsset);
        PlantEntityAsset leafAsset = this.plantEntityAssetDictionary.getPlantEntityAsset(this.leafAssetType, attributes);
        physicalComponent.getTypeMap().put(this.leafAssetType, leafAsset);
        if (attributes.getSpecies().getFruit() != null) {
            PlantEntityAsset fruitAsset = this.plantEntityAssetDictionary.getPlantEntityAsset(this.fruitAssetType, attributes);
            physicalComponent.getTypeMap().put(this.fruitAssetType, fruitAsset);
        }
    }

    private void updateItemAssets(Entity entity) {
        ItemEntityAttributes attributes = (ItemEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
        ItemEntityAsset baseAsset = this.itemEntityAssetDictionary.getItemEntityAsset(this.itemBaseLayer, attributes);
        entity.getPhysicalEntityComponent().setBaseAsset(baseAsset);
        if (baseAsset != null) {
            entity.getPhysicalEntityComponent().getTypeMap().put(baseAsset.getType(), baseAsset);
            this.addOtherItemAssetTypes(baseAsset.getType(), entity.getPhysicalEntityComponent(), attributes);
        }
    }

    private void addOtherHumanoidAssetTypes(EntityAssetType assetType, PhysicalEntityComponent physicalComponent, HumanoidEntityAttributes attributes, Profession primaryProfession) {
        HumanoidEntityAsset asset = this.humanoidEntityAssetDictionary.getHumanoidEntityAsset(assetType, attributes, primaryProfession);
        if (asset != null && asset.getType() != null) {
            physicalComponent.getTypeMap().put(asset.getType(), asset);
            HashSet<EntityAssetType> attachedTypes = new HashSet<EntityAssetType>();
            for (SpriteDescriptor spriteDescriptor : asset.getSpriteDescriptors().values()) {
                for (EntityChildAssetDescriptor childAssetDescriptor : spriteDescriptor.getChildAssets()) {
                    if (childAssetDescriptor.getSpecificAssetName() != null) continue;
                    attachedTypes.add(childAssetDescriptor.getType());
                }
            }
            for (EntityAssetType attachedType : attachedTypes) {
                this.addOtherHumanoidAssetTypes(attachedType, physicalComponent, attributes, primaryProfession);
            }
        }
    }

    private void addOtherItemAssetTypes(EntityAssetType assetType, PhysicalEntityComponent physicalComponent, ItemEntityAttributes attributes) {
        ItemEntityAsset asset = this.itemEntityAssetDictionary.getItemEntityAsset(assetType, attributes);
        if (asset != null) {
            physicalComponent.getTypeMap().put(asset.getType(), asset);
            HashSet<EntityAssetType> attachedTypes = new HashSet<EntityAssetType>();
            for (SpriteDescriptor spriteDescriptor : asset.getSpriteDescriptors().values()) {
                for (EntityChildAssetDescriptor childAssetDescriptor : spriteDescriptor.getChildAssets()) {
                    if (childAssetDescriptor.getSpecificAssetName() != null) continue;
                    attachedTypes.add(childAssetDescriptor.getType());
                }
            }
            for (EntityAssetType attachedType : attachedTypes) {
                this.addOtherItemAssetTypes(attachedType, physicalComponent, attributes);
            }
        }
    }

    private void updateFurnitureAssets(Entity entity) {
        EntityAttributes abstractAttributes = entity.getPhysicalEntityComponent().getAttributes();
        if (abstractAttributes instanceof FurnitureEntityAttributes) {
            FurnitureEntityAttributes attributes = (FurnitureEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
            FurnitureEntityAsset baseAsset = this.furnitureEntityAssetDictionary.getFurnitureEntityAsset(attributes);
            entity.getPhysicalEntityComponent().setBaseAsset(baseAsset);
            entity.getPhysicalEntityComponent().getTypeMap().put(baseAsset.getType(), baseAsset);
        }
        LinkedList<Tag> attachedTags = new LinkedList<Tag>();
        this.addTags(entity, attachedTags);
        this.tagProcessor.apply(attachedTags, entity);
    }

    private void addTags(Entity entity, List<Tag> attachedTags) {
        for (EntityAsset entityAsset : entity.getPhysicalEntityComponent().getTypeMap().values()) {
            if (entityAsset.getTags() == null || entityAsset.getTags().isEmpty()) continue;
            for (Map.Entry<String, List<String>> entry : entityAsset.getTags().entrySet()) {
                try {
                    TagType tagType = TagType.valueOf(entry.getKey());
                    Tag tag = tagType.newInstance();
                    tag.setArgs(entry.getValue());
                    attachedTags.add(tag);
                }
                catch (RuntimeException e) {
                    System.err.println("Unrecognised tag: " + entry.getKey());
                }
            }
        }
        for (AttachedEntity attachedEntity : entity.getAttachedEntities()) {
            this.addTags(attachedEntity.entity, attachedTags);
        }
    }
}

